package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdatosReqOs;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdatosReqOsDaoImpl generated by UDA, 20-jun-2017 10:04:30.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VdatosReqOsDaoImpl implements VdatosReqOsDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VdatosReqOs> rwMap = new RowMapper<VdatosReqOs>() {
		public VdatosReqOs mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdatosReqOs(resultSet.getString("ANOOS"),
					resultSet.getString("TEROS"), resultSet.getInt("NUMOS"),
					resultSet.getString("TIPOOS"), resultSet.getDate("FECPRE"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("PRVCTR"),
					resultSet.getString("MUNCTR"),
					resultSet.getString("DESCMUNI"),
					resultSet.getString("NOMEMP"), resultSet.getString("PIE1"),
					resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"));
		}
	};

	private RowMapper<VdatosReqOs> rwMapPK = new RowMapper<VdatosReqOs>() {
		public VdatosReqOs mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdatosReqOs(resultSet.getString("ANOOS"),
					resultSet.getString("TEROS"), resultSet.getInt("NUMOS"),
					resultSet.getString("TIPOOS"), resultSet.getDate("FECPRE"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("PRVCTR"),
					resultSet.getString("MUNCTR"),
					resultSet.getString("DESCMUNI"),
					resultSet.getString("NOMEMP"), resultSet.getString("PIE1"),
					resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VdatosReqOs table.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @return the vdatos req os
	 */
	public VdatosReqOs add(VdatosReqOs vdatosreqos) {
		String query = "INSERT INTO VDATOS_REQ_OS (ANOOS, TEROS, NUMOS, TIPOOS, FECPRE, DIRCTR, PRVCTR, MUNCTR, DESCMUNI, NOMEMP, PIE1, PIE2, DESCFIRMA, FIRMA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vdatosreqos.getAnoos(),
				vdatosreqos.getTeros(), vdatosreqos.getNumos(),
				vdatosreqos.getTipoos(), vdatosreqos.getFecpre(),
				vdatosreqos.getDirctr(), vdatosreqos.getPrvctr(),
				vdatosreqos.getMunctr(), vdatosreqos.getDescmuni(),
				vdatosreqos.getNomemp(), vdatosreqos.getPie1(),
				vdatosreqos.getPie2(), vdatosreqos.getDescfirma(),
				vdatosreqos.getFirma());
		return vdatosreqos;
	}

	/**
	 * Updates a single row in the VdatosReqOs table.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @return the vdatos req os
	 */
	public VdatosReqOs update(VdatosReqOs vdatosreqos) {
		String query = "UPDATE VDATOS_REQ_OS SET  WHERE ANOOS=? AND TEROS=? AND NUMOS=? AND TIPOOS=? AND FECPRE=? AND DIRCTR=? AND PRVCTR=? AND MUNCTR=? AND DESCMUNI=? AND NOMEMP=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=?";
		this.jdbcTemplate.update(query, vdatosreqos.getAnoos(),
				vdatosreqos.getTeros(), vdatosreqos.getNumos(),
				vdatosreqos.getTipoos(), vdatosreqos.getFecpre(),
				vdatosreqos.getDirctr(), vdatosreqos.getPrvctr(),
				vdatosreqos.getMunctr(), vdatosreqos.getDescmuni(),
				vdatosreqos.getNomemp(), vdatosreqos.getPie1(),
				vdatosreqos.getPie2(), vdatosreqos.getDescfirma(),
				vdatosreqos.getFirma());
		return vdatosreqos;
	}

	/**
	 * Finds a single row in the VdatosReqOs table.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @return the vdatos req os
	 */
	@Transactional(readOnly = true)
	public VdatosReqOs find(VdatosReqOs vdatosreqos) {
		String query = "SELECT t1.ANOOS ANOOS, t1.TEROS TEROS, t1.NUMOS NUMOS, t1.TIPOOS TIPOOS, t1.FECPRE FECPRE, t1.DIRCTR DIRCTR, t1.PRVCTR PRVCTR, t1.MUNCTR MUNCTR, t1.DESCMUNI DESCMUNI, t1.NOMEMP NOMEMP, t1.PIE1 PIE1, t1.PIE2 PIE2, t1.DESCFIRMA DESCFIRMA, t1.FIRMA FIRMA FROM VDATOS_REQ_OS t1  WHERE t1.ANOOS = ?   AND t1.TEROS = ?   AND t1.NUMOS = ?  AND t1.TIPOOS = ? ";

		List<VdatosReqOs> vdatosreqosList = this.jdbcTemplate.query(query,
				this.rwMap, vdatosreqos.getAnoos(), vdatosreqos.getTeros(),
				vdatosreqos.getNumos(), vdatosreqos.getTipoos());
		return (VdatosReqOs) DataAccessUtils.uniqueResult(vdatosreqosList);
	}

	/**
	 * Removes a single row in the VdatosReqOs table.
	 * 
	 *  vdatosreqos            VdatosReqOs
	 *
	 * @param vdatosreqos the vdatosreqos
	 */
	public void remove(VdatosReqOs vdatosreqos) {
		String query = "DELETE FROM VDATOS_REQ_OS WHERE ANOOS=? AND TEROS=? AND NUMOS=? AND TIPOOS=? AND FECPRE=? AND DIRCTR=? AND PRVCTR=? AND MUNCTR=? AND DESCMUNI=? AND NOMEMP=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=?";
		this.jdbcTemplate.update(query, vdatosreqos.getAnoos(),
				vdatosreqos.getTeros(), vdatosreqos.getNumos(),
				vdatosreqos.getTipoos(), vdatosreqos.getFecpre(),
				vdatosreqos.getDirctr(), vdatosreqos.getPrvctr(),
				vdatosreqos.getMunctr(), vdatosreqos.getDescmuni(),
				vdatosreqos.getNomemp(), vdatosreqos.getPie1(),
				vdatosreqos.getPie2(), vdatosreqos.getDescfirma(),
				vdatosreqos.getFirma());
	}

	/**
	 * Finds a list of rows in the VdatosReqOs table.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdatosReqOs>
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdatosReqOs> findAll(VdatosReqOs vdatosreqos,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANOOS ANOOS,t1.TEROS TEROS,t1.NUMOS NUMOS,t1.TIPOOS TIPOOS,t1.FECPRE FECPRE,t1.DIRCTR DIRCTR,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.DESCMUNI DESCMUNI,t1.NOMEMP NOMEMP,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		query.append("FROM VDATOS_REQ_OS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdatosreqos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdatosReqOs>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VdatosReqOs table using like.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdatosReqOs>
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdatosReqOs> findAllLike(VdatosReqOs vdatosreqos,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANOOS ANOOS,t1.TEROS TEROS,t1.NUMOS NUMOS,t1.TIPOOS TIPOOS,t1.FECPRE FECPRE,t1.DIRCTR DIRCTR,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.DESCMUNI DESCMUNI,t1.NOMEMP NOMEMP,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		query.append("FROM VDATOS_REQ_OS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(vdatosreqos, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdatosReqOs>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VdatosReqOs table.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  Long
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VdatosReqOs vdatosreqos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDATOS_REQ_OS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdatosreqos);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VdatosReqOs table using like.
	 * 
	 *  vdatosreqos
	 *            VdatosReqOs
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VdatosReqOs vdatosreqos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDATOS_REQ_OS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(vdatosreqos, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VdatosReqOs selected for rup_table.
	 * 
	 *  vdatosreqos            VdatosReqOs
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdatosReqOs>>
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdatosReqOs>> reorderSelection(
			VdatosReqOs vdatosreqos, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANOOS ANOOS,t1.TEROS TEROS,t1.NUMOS NUMOS,t1.TIPOOS TIPOOS,t1.FECPRE FECPRE,t1.DIRCTR DIRCTR,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.DESCMUNI DESCMUNI,t1.NOMEMP NOMEMP,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VDATOS_REQ_OS t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(vdatosreqos, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VdatosReqOs.class,
						filterParamList,
						"ANOOS,TEROS,NUMOS,TIPOOS,FECPRE,DIRCTR,PRVCTR,MUNCTR,DESCMUNI,NOMEMP,PIE1,PIE2,DESCFIRMA,FIRMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdatosReqOs>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VdatosReqOs
	 *  searchParams            VdatosReqOs
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdatosReqOs>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdatosReqOs>> search(VdatosReqOs filterParams,
			VdatosReqOs searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANOOS ANOOS,t1.TEROS TEROS,t1.NUMOS NUMOS,t1.TIPOOS TIPOOS,t1.FECPRE FECPRE,t1.DIRCTR DIRCTR,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.DESCMUNI DESCMUNI,t1.NOMEMP NOMEMP,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VDATOS_REQ_OS t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VdatosReqOs.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"ANOOS,TEROS,NUMOS,TIPOOS,FECPRE,DIRCTR,PRVCTR,MUNCTR,DESCMUNI,NOMEMP,PIE1,PIE2,DESCFIRMA,FIRMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdatosReqOs>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervdatosreqos            VdatosReqOs
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervdatosreqos the filtervdatosreqos
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VdatosReqOs filtervdatosreqos,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANOOS ANOOS,t1.TEROS TEROS,t1.NUMOS NUMOS,t1.TIPOOS TIPOOS,t1.FECPRE FECPRE,t1.DIRCTR DIRCTR,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.DESCMUNI DESCMUNI,t1.NOMEMP NOMEMP,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VDATOS_REQ_OS t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervdatosreqos,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VdatosReqOs.class,
						query,
						params,
						"ANOOS,TEROS,NUMOS,TIPOOS,FECPRE,DIRCTR,PRVCTR,MUNCTR,DESCMUNI,NOMEMP,PIE1,PIE2,DESCFIRMA,FIRMA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdatosReqOs entity.
	 * 
	 *  vdatosreqos            VdatosReqOs Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VdatosReqOs vdatosreqos) {

		StringBuilder where = new StringBuilder(
				VdatosReqOsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdatosreqos != null && vdatosreqos.getAnoos() != null) {
			where.append(" AND t1.ANOOS = ?");
			params.add(vdatosreqos.getAnoos());
		}
		if (vdatosreqos != null && vdatosreqos.getTeros() != null) {
			where.append(" AND t1.TEROS = ?");
			params.add(vdatosreqos.getTeros());
		}
		if (vdatosreqos != null && vdatosreqos.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vdatosreqos.getNumos());
		}
		if (vdatosreqos != null && vdatosreqos.getTipoos() != null) {
			where.append(" AND t1.TIPOOS = ?");
			params.add(vdatosreqos.getTipoos());
		}
		if (vdatosreqos != null && vdatosreqos.getFecpre() != null) {
			where.append(" AND t1.FECPRE = ?");
			params.add(vdatosreqos.getFecpre());
		}
		if (vdatosreqos != null && vdatosreqos.getDirctr() != null) {
			where.append(" AND t1.DIRCTR = ?");
			params.add(vdatosreqos.getDirctr());
		}
		if (vdatosreqos != null && vdatosreqos.getPrvctr() != null) {
			where.append(" AND t1.PRVCTR = ?");
			params.add(vdatosreqos.getPrvctr());
		}
		if (vdatosreqos != null && vdatosreqos.getMunctr() != null) {
			where.append(" AND t1.MUNCTR = ?");
			params.add(vdatosreqos.getMunctr());
		}
		if (vdatosreqos != null && vdatosreqos.getDescmuni() != null) {
			where.append(" AND t1.DESCMUNI = ?");
			params.add(vdatosreqos.getDescmuni());
		}
		if (vdatosreqos != null && vdatosreqos.getNomemp() != null) {
			where.append(" AND t1.NOMEMP = ?");
			params.add(vdatosreqos.getNomemp());
		}
		if (vdatosreqos != null && vdatosreqos.getPie1() != null) {
			where.append(" AND t1.PIE1 = ?");
			params.add(vdatosreqos.getPie1());
		}
		if (vdatosreqos != null && vdatosreqos.getPie2() != null) {
			where.append(" AND t1.PIE2 = ?");
			params.add(vdatosreqos.getPie2());
		}
		if (vdatosreqos != null && vdatosreqos.getDescfirma() != null) {
			where.append(" AND t1.DESCFIRMA = ?");
			params.add(vdatosreqos.getDescfirma());
		}
		if (vdatosreqos != null && vdatosreqos.getFirma() != null) {
			where.append(" AND t1.FIRMA = ?");
			params.add(vdatosreqos.getFirma());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdatosReqOs entity.
	 * 
	 *  vdatosreqos            VdatosReqOs Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdatosreqos the vdatosreqos
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VdatosReqOs vdatosreqos,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VdatosReqOsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdatosreqos != null && vdatosreqos.getAnoos() != null) {
			where.append(" AND UPPER(t1.ANOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getAnoos().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getAnoos().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getTeros() != null) {
			where.append(" AND UPPER(t1.TEROS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getTeros().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getTeros().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(vdatosreqos.getNumos());
		}
		if (vdatosreqos != null && vdatosreqos.getTipoos() != null) {
			where.append(" AND UPPER(t1.TIPOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getTipoos().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getTipoos().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOOS IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getFecpre() != null) {
			where.append(" AND t1.FECPRE = ?");
			params.add(vdatosreqos.getFecpre());
		}
		if (vdatosreqos != null && vdatosreqos.getDirctr() != null) {
			where.append(" AND UPPER(t1.DIRCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getDirctr().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getDirctr().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRCTR IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getPrvctr() != null) {
			where.append(" AND UPPER(t1.PRVCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getPrvctr().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getPrvctr().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVCTR IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getMunctr() != null) {
			where.append(" AND UPPER(t1.MUNCTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getMunctr().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getMunctr().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNCTR IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getDescmuni() != null) {
			where.append(" AND UPPER(t1.DESCMUNI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getDescmuni().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getDescmuni().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCMUNI IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getNomemp() != null) {
			where.append(" AND UPPER(t1.NOMEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getNomemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getNomemp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMP IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getPie1() != null) {
			where.append(" AND UPPER(t1.PIE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getPie1().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getPie1().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE1 IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getPie2() != null) {
			where.append(" AND UPPER(t1.PIE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getPie2().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getPie2().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE2 IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getDescfirma() != null) {
			where.append(" AND UPPER(t1.DESCFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getDescfirma().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getDescfirma().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCFIRMA IS NOT NULL");
		}
		if (vdatosreqos != null && vdatosreqos.getFirma() != null) {
			where.append(" AND UPPER(t1.FIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdatosreqos.getFirma().toUpperCase() + "%");
			} else {
				params.add("%" + vdatosreqos.getFirma().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
